'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Public Sub Markierung_Setzen(ByRef Wert As Boolean)
    Dim dbs As Database
    Dim rst As Recordset
    Dim txt As String
    
    Set dbs = CurrentDb
    
    'Ermittlung, wieviel Eintrge die aktuelle Liste hat
    Set rst = Me.RecordsetClone
    If rst.RecordCount = 0 Then
        rst.Close
        Exit Sub
    End If
    'Filter vorbereiten
    rst.MoveLast    'auffllen
    rst.MoveFirst
    Select Case Mehrfachwahl_Primaer
        Case "Kalender", "NurKategorien"
            txt = "SELECT Auswahl FROM Mehrfachwahl WHERE Tab1_lfd_Nr = " & rst!Tab1_lfd_Nr
        Case "Kategorie", "NurKalender"
            txt = "SELECT Auswahl FROM Mehrfachwahl WHERE Tab2_lfd_Nr = " & rst!Tab2_lfd_Nr
    End Select
    rst.Close
    
    'Alle Eintrge bearbeiten
    Set rst = dbs.OpenRecordset(txt)
    If rst.RecordCount > 0 Then
        rst.MoveLast    'auffllen
        rst.MoveFirst
        Do While Not rst.EOF
            rst.Edit
            rst!Auswahl = Wert
            rst.Update
            rst.MoveNext
        Loop
    End If
    rst.Close
    
    'Anreige aktualisieren
    Call Zaehler_in_Merfachwahl_PreisNeu_aktualisieren
End Sub

Private Sub Button_Markieren_Alle_Click()
    Markierung_Setzen True
End Sub

Private Sub Button_Markieren_keine_Click()
    Markierung_Setzen False
End Sub

Private Sub Form_AfterUpdate()
    Call Zaehler_in_Merfachwahl_PreisNeu_aktualisieren
End Sub

Private Sub Form_Current()
    'Fhrt hier im Unterformular zu einem Stapel-Speicher-berlauf(!):
    '   Call Zaehler_in_Merfachwahl_PreisNeu_aktualisieren
    'weil die Routine vermutlich fr jeden Listeneintrag aufgerufen wird
    
End Sub

Private Sub Form_Open(Cancel As Integer)
    Me.Text_Betrag.Format = "Currency"
    Me.Text_Preis.Format = "Currency"
    
    'Felder ein-/ausblenden
    Select Case Mehrfachwahl_Primaer
        Case "Kalender", "NurKategorien"
            Me.Kombi_Tab1.Visible = False       'Kalender
            Me.Kombi_Tab2.Visible = True        'Kategorien
        Case "Kategorie", "NurKalender"
            Me.Kombi_Tab1.Visible = True        'Kalender
            Me.Kombi_Tab2.Visible = False       'Kategorien
    End Select
End Sub
